<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 2.3
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2025 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\components\widgets;

use yii\helpers\Html;

/**
 * Class CheckboxColumn
 * @package app\components\widgets
 */
class CheckboxColumn extends \kartik\grid\CheckboxColumn
{

    public $cssClass = 'form-check-input';

    protected function renderHeaderCellContent(): string
    {
        if ($this->header !== null || !$this->multiple) {
            return parent::renderHeaderCellContent();
        }

        return Html::checkbox($this->getHeaderCheckBoxName(), false, ['class' => 'form-check-input select-on-check-all']);
    }
}